; ----------------------------------------------------------------------------
;
; AutoIt Version: 3.2.1.13
; Author:         JPM
;
; Script Function:
;	Display AutoIt default Running release.
;
; ----------------------------------------------------------------------------

; Script Start - Add your code below here

Opt("MustDeclareVars",1)
Local $InstallDir = RegRead("HKLM\Software\AutoIt v3\AutoIt","InstallDir")
If $InstallDir = "" Then $InstallDir = RegRead("HKLM\Software\Wow6432Node\AutoIt v3\AutoIt","InstallDir")
If $InstallDir = "" Then
	MsgBox(0,'Error', 'Cannot find AutoIt Installation directory')
	Exit
EndIf

;If StringInStr(RegRead("HKLM\Software\Classes\AutoIt3Script\Shell\Run\Command",""),"beta") Then
If StringInStr(RegRead("HKCR\.au3",""),"Beta") Then
    Local $AutoItEnv = "Beta " & FileGetVersion($InstallDir & '\beta\AutoIt3.exe') & _
					" (" & StringLeft(FileGetTime($InstallDir & '\beta\AutoIt3.exe',0,1),4) & _
					"/" & StringMid(FileGetTime($InstallDir & '\beta\AutoIt3.exe',0,1),5,2) & _
					"/" & StringMid(FileGetTime($InstallDir & '\beta\AutoIt3.exe',0,1),7,2) & ")"
Else
    Local $AutoItEnv = "Release " & FileGetVersion($InstallDir & '\AutoIt3.exe') & _
					" (" & StringLeft(FileGetTime($InstallDir & '\AutoIt3.exe',0,1),4) & _
					"/" & StringMid(FileGetTime($InstallDir & '\AutoIt3.exe',0,1),5,2) & _
					"/" & StringMid(FileGetTime($InstallDir & '\AutoIt3.exe',0,1),7,2) & ")"
EndIf

If @AutoItX64 Then
	Local $AutoItX64 = "X64 "
Else
	Local $AutoItX64 = "X86 "
EndIf
Local $Compiled = ""
If @Compiled Then $Compiled = " Compiled"
Local $OsServicePack=""
If @OSServicePack Then $OsServicePack = "/" & @OSServicePack
Local $SystemEnv = "Running under :" & @CRLF & @CRLF & @OSVersion & $OsServicePack & " (" & @OSArch & ")" & @CRLF & @TAB & "CPUArch=" & @CPUArch

MsgBox(0,"AutoIt default", $AutoItX64 & $AutoItEnv & $Compiled & _
							 @CRLF & @CRLF & $SystemEnv _
					,5)
